function ModYlm=Fonc_ModuleHarmoniqueSpherique(l,m,theta)
%
%   Cette fonction calcule l'harmonique sphrique d'expression 
%   gnrale :
%
%   Y(l,m)=((2l+1)(l-m)!/((l+m)!4pi))^0.5 P(l,m)exp(i*m*phi)
% 
%   Entres :   l = moment cintique orbital (Nombre quantique)
%               m = Nombre quantique magntique (|m|<l)
%               phi     = angle azimutal
%               theta   = colatitude
%   Sorties :   Y(l,m)  = Harmonique sphrique
%
% Olivier Pujol : septembre 2013

%% Calcul du polynme de Legendre correspondant

% La fonction "legendre(l,X)", interne  Matlab, calcule P(l,m) pour chaque 
% lment (k) de X, compris imprativement entre -1 et 1.
% La matrice obtenue est de dimension (l+1)*length(X) ;  
% chacun de ses lments P(m+1,k) correspond  P(l,m) valu en X(k). 
% Soulignons que pour la premire ligne de P, m=0.

P=legendre(l,cos(theta(:,1)));          % Polynme de Legendre

%% Calcul du module de l'harmonique sphrique considre

Facteur =((2*l+1)*factorial(l-m)/(4*pi*factorial(l+m)))^0.5; % Rel positif

Ntheta=size(theta,1);
ModYlm=nan(Ntheta,1);

if (l == 0)
    ModYlm = Facteur.*P;  % Dans ce cas, P = 1 quel que soit phi (|Y(0,0)|)
else
    Plm=P(abs(m)+1,:);  % P(m+1,k) = P(l,m). Ici, Plm = matrice (NbPoints * NbPoints)
    iplm=1;             % Initialisation de l'indice de Plm
    for itheta=1:Ntheta
        ModYlm(itheta) = abs(Facteur.*Plm(iplm));  % |Y(l,m)|
        iplm=iplm+1;
    end
end

return